/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.compras;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ProveedorContextoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ValoresComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaComprobanteCompra;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaFormasDePago;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaPagoLocal;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaProveedor;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaValoresComprobante;
import java.math.BigDecimal;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteNuevaCompra
extends AsistenteBase
implements INewWizard {
    private PaginaProveedor paginaProveedor;
    private PaginaComprobanteCompra paginaComprobante;
    private PaginaValoresComprobante paginaValores;
    private PaginaPagoLocal paginaPagoLocal;
    private PaginaFormasDePago formasPago;
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.exportaciones.AsistenteNuevaExportacion";
    private final TransaccionCompra modeloDatos;
    private final TransaccionCompra copiaValidacion;
    private boolean editando;
    private Periodo periodo;

    public AsistenteNuevaCompra(TransaccionCompra compra, boolean editando, Periodo periodo) {
        this.modeloDatos = compra;
        this.periodo = periodo;
        this.modeloDatos.getComprobanteCompra().setObligatorio(true);
        this.copiaValidacion = new TransaccionCompra();
        this.copiaValidacion.setPropietario((ObjetoModelo)((Iva)this.modeloDatos.getPropietario()));
        this.copiaValidacion.getComprobanteRetencion().inicializar();
        this.copiaValidacion.getComprobanteRetencion().setObligatorio(false);
        this.editando = editando;
        this.copiaValidacion.getComprobanteRetencion().setProveedorContextoValidacion(new ProveedorContextoValidacion(){

            public ContextoValidacion getContextoValidacion() {
                ContextoValidacion ctxVal = new ContextoValidacion();
                ctxVal.agregar("FECHA_COMPROBANTE", (Object)AsistenteNuevaCompra.this.modeloDatos.getComprobanteCompra().getFechaEmision());
                ctxVal.agregar("FECHA_REGISTRO", (Object)AsistenteNuevaCompra.this.modeloDatos.getComprobanteCompra().getFechaRegistro());
                return ctxVal;
            }
        });
    }

    public void addPages() {
        this.paginaProveedor = new PaginaProveedor(this.editando, this.periodo);
        this.paginaProveedor.setModeloDatos(this.modeloDatos.getProveedor());
        this.paginaProveedor.inicializarModeloValores();
        this.paginaComprobante = new PaginaComprobanteCompra(this.editando);
        this.modeloDatos.getComprobanteCompra().inicializar();
        this.paginaComprobante.setModeloDatos(this.modeloDatos);
        this.paginaComprobante.inicializarModeloValores();
        this.paginaValores = new PaginaValoresComprobante(this.editando, this.periodo);
        this.paginaValores.setModeloDatos(this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta());
        this.paginaPagoLocal = new PaginaPagoLocal(this.editando, this.periodo);
        this.paginaPagoLocal.setModeloDatos(this.copiaValidacion);
        this.paginaPagoLocal.inicializarModeloValores();
        this.formasPago = new PaginaFormasDePago(this.editando, this.periodo);
        this.formasPago.setWizard((IWizard)this);
        this.formasPago.setModeloDatos(this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta());
        this.formasPago.inicializarModeloValores();
        this.addPage((IWizardPage)this.paginaProveedor);
        this.addPage((IWizardPage)this.paginaComprobante);
        this.addPage((IWizardPage)this.paginaValores);
        this.addPage((IWizardPage)this.paginaPagoLocal);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        ValoresComprobanteVenta valores = this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta();
        if (page.equals((Object)this.paginaPagoLocal)) {
            boolean esNotaDeCredito = this.modeloDatos.getComprobanteCompra().getTipoComprobante().equals("04");
            if (valores.getTotalSumaFormasPago().compareTo(this.obtenerLimiteFormasPago(this.periodo)) >= 0 && !esNotaDeCredito && ((Iva)this.modeloDatos.getPropietario()).periodo.isPeriodoDesdeEnero2013()) {
                this.formasPago.refrescarControles();
                return this.formasPago;
            }
            valores.getFormasPago().clear();
        }
        if (page.equals((Object)this.formasPago)) {
            return null;
        }
        if (page.equals((Object)this.paginaProveedor)) {
            this.paginaComprobante.filtarSustentos();
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page.equals((Object)this.formasPago)) {
            return this.paginaPagoLocal;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof PaginaPagoLocal) {
            ValoresComprobanteVenta valores = this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta();
            boolean esNotaDebitoOCredito = this.modeloDatos.getComprobanteCompra().getTipoComprobante().equals("04");
            return currentPage.isPageComplete() && (valores.getTotalSumaFormasPago().compareTo(Constantes.MIL) < 0 || esNotaDebitoOCredito || ((Iva)this.modeloDatos.getPropietario()).periodo.isPeriodoAnteriorA2013());
        }
        if (currentPage instanceof PaginaFormasDePago) {
            return currentPage.isPageComplete();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        this.modeloDatos.getPagoLocalExterior().actualizarInformacion(this.copiaValidacion.getPagoLocalExterior());
        this.modeloDatos.getComprobanteRetencion().actualizarInformacion((Comprobante)this.copiaValidacion.getComprobanteRetencion());
        return true;
    }

    private BigDecimal obtenerLimiteFormasPago(Periodo pPeriodo) {
        BigDecimal valor = Constantes.MIL;
        if (pPeriodo.getAnio() >= 2024) {
            valor = Constantes.QUINIENTOS;
        }
        return valor;
    }
}

